/*
 * Decompiled with CFR 0.152.
 */
package datechooser.autorun;

import datechooser.autorun.ConfigBean;
import datechooser.autorun.ConfigCombo;
import datechooser.autorun.ConfigDialog;
import datechooser.autorun.ConfigPanel;
import datechooser.beans.locale.LocaleUtils;
import datechooser.beans.pic.Pictures;
import datechooser.events.CommitEvent;
import datechooser.events.CommitListener;
import datechooser.events.SelectionChangedEvent;
import datechooser.events.SelectionChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.IntrospectionException;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class ConfigWindow
extends JFrame
implements CommitListener,
SelectionChangedListener {
    private static final int WIDTH = 630;
    private static final int HEIGHT = 380;
    private static final String MENU_PROPERTY_ID = "MenuItemID";
    private static final String MENU_LOAD = "load";
    private static final String MENU_SAVE = "save";
    private static final String MENU_SAVE_AS = "save as";
    private JPanel mainPane;
    private ConfigBean[] configurators;
    private JLabel selectedBeanNameLabel;
    private int selected;
    private JTextArea output;
    private ButtonGroup selLookFeel;
    private String about;
    private ImageIcon aboutImage;
    private JFileChooser fileChooser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigWindow() throws IntrospectionException {
        LocaleUtils.prepareStandartDialogButtonText();
        this.setDefaultCloseOperation(0);
        this.setTitle(LocaleUtils.getConfigLocaleString("Caption"));
        this.mainPane = new JPanel(new BorderLayout(5, 2));
        this.configurators = new ConfigBean[]{new ConfigPanel(), new ConfigCombo(), new ConfigDialog()};
        this.selected = 0;
        this.setJMenuBar(this.createMenuBar());
        this.selectedBeanNameLabel = this.createBeanNameOutput();
        this.mainPane.add((Component)this.selectedBeanNameLabel, "North");
        this.mainPane.add((Component)this.getCurrentConfigBean(), "Center");
        this.output = this.createOutput();
        this.mainPane.add((Component)this.output, "South");
        this.setContentPane(this.mainPane);
        this.updateOutput();
        this.setCentered();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
        this.registerAsListener();
        this.setAllSaved();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new ComponentFileFilter());
        this.addWindowListener(new OnWindowClose());
    }

    private void setAllSaved() {
        for (ConfigBean configBean : this.configurators) {
            configBean.setSaved(true);
        }
    }

    private JLabel createBeanNameOutput() {
        JLabel selectedBean = new JLabel(this.getCurrentConfigBean().getBeanDisplayName());
        selectedBean.setHorizontalAlignment(0);
        selectedBean.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return selectedBean;
    }

    private JTextArea createOutput() {
        JTextArea output = new JTextArea("");
        output.setRows(2);
        output.setLineWrap(true);
        output.setWrapStyleWord(true);
        output.setOpaque(false);
        output.setEditable(false);
        return output;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createMenuFile());
        menuBar.add(this.createMenuBean());
        menuBar.add(this.createMenuLF());
        menuBar.add(this.createMenuHelp());
        return menuBar;
    }

    private JFrame getFrame() {
        return this;
    }

    private JMenu createMenuHelp() {
        JMenu menuHelp = new JMenu(LocaleUtils.getConfigLocaleString("Help"));
        JMenuItem menuAbout = new JMenuItem(LocaleUtils.getConfigLocaleString("About"));
        StringBuffer aboutString = new StringBuffer("<html>");
        aboutString.append(LocaleUtils.getConfigLocaleString("ProjectName"));
        aboutString.append("<br><br>(c) ");
        aboutString.append(LocaleUtils.getConfigLocaleString("Author"));
        aboutString.append(", 2014<br>");
        aboutString.append("e-mail: <i>androsovvi@gmail.com</i>");
        this.about = aboutString.toString();
        this.aboutImage = new ImageIcon(Pictures.getResource("logo_small.gif"));
        menuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(ConfigWindow.this.getFrame(), ConfigWindow.this.about, LocaleUtils.getConfigLocaleString("About"), 1, ConfigWindow.this.aboutImage);
            }
        });
        menuHelp.add(menuAbout);
        return menuHelp;
    }

    private JMenu createMenuLF() {
        JMenu menuLF = new JMenu(LocaleUtils.getConfigLocaleString("LookFeel"));
        UIManager.LookAndFeelInfo[] lf = UIManager.getInstalledLookAndFeels();
        this.selLookFeel = new ButtonGroup();
        LookAndFeel current = UIManager.getLookAndFeel();
        OnLookAndFeelChange onChange = new OnLookAndFeelChange();
        for (UIManager.LookAndFeelInfo lookAndFeel : lf) {
            String lfName = lookAndFeel.getName();
            JCheckBoxMenuItem miLF = new JCheckBoxMenuItem(lfName);
            miLF.putClientProperty(MENU_PROPERTY_ID, lookAndFeel.getClassName());
            miLF.addActionListener(onChange);
            if (current != null && current.getName().equals(lfName)) {
                miLF.setSelected(true);
            }
            this.selLookFeel.add(miLF);
            menuLF.add(miLF);
        }
        return menuLF;
    }

    private JMenu createMenuFile() {
        OnStoreAction onStore = new OnStoreAction();
        JMenu menuFile = new JMenu(LocaleUtils.getConfigLocaleString("File"));
        JMenuItem menuLoad = new JMenuItem(LocaleUtils.getConfigLocaleString("Load"));
        menuLoad.putClientProperty(MENU_PROPERTY_ID, MENU_LOAD);
        menuLoad.addActionListener(onStore);
        menuFile.add(menuLoad);
        menuFile.addSeparator();
        JMenuItem menuSave = new JMenuItem(LocaleUtils.getConfigLocaleString("Save"));
        menuSave.putClientProperty(MENU_PROPERTY_ID, MENU_SAVE);
        menuSave.addActionListener(onStore);
        menuFile.add(menuSave);
        JMenuItem menuSaveAs = new JMenuItem(LocaleUtils.getConfigLocaleString("SaveAs"));
        menuSaveAs.putClientProperty(MENU_PROPERTY_ID, MENU_SAVE_AS);
        menuSaveAs.addActionListener(onStore);
        menuFile.add(menuSaveAs);
        menuFile.addSeparator();
        JMenuItem menuExit = new JMenuItem(LocaleUtils.getConfigLocaleString("Exit"));
        menuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigWindow.this.tryToExit();
            }
        });
        menuFile.add(menuExit);
        return menuFile;
    }

    private void tryToExit() {
        int ans;
        String unsaved = this.getUnsaved();
        if (!this.getUnsaved().equals("") && (ans = JOptionPane.showConfirmDialog(this.getFrame(), "<html> " + LocaleUtils.getConfigLocaleString("Exit_no_save") + " <br><UL>" + unsaved + "</UL>", LocaleUtils.getConfigLocaleString("Exit"), 0)) == 1) {
            return;
        }
        System.exit(0);
    }

    private String getUnsaved() {
        StringBuffer unsaved = new StringBuffer("");
        for (ConfigBean configurator : this.configurators) {
            if (configurator.isSaved()) continue;
            unsaved.append("<LI>");
            unsaved.append(configurator.getBeanDisplayName());
        }
        return unsaved.toString();
    }

    private JMenu createMenuBean() {
        JMenu menuBean = new JMenu(LocaleUtils.getConfigLocaleString("Bean"));
        OnBeanChange onBeanChange = new OnBeanChange();
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.configurators.length; ++i) {
            String beanName = this.configurators[i].getBeanDisplayName();
            JCheckBoxMenuItem menuCurrentBean = new JCheckBoxMenuItem(beanName);
            menuCurrentBean.putClientProperty(MENU_PROPERTY_ID, new Integer(i));
            menuCurrentBean.addActionListener(onBeanChange);
            menuCurrentBean.setSelected(this.getSelected() == i);
            group.add(menuCurrentBean);
            menuBean.add(menuCurrentBean);
        }
        return menuBean;
    }

    private void registerAsListener() {
        for (ConfigBean beanConfigurator : this.configurators) {
            beanConfigurator.getBean().addCommitListener(this);
            beanConfigurator.getBean().addSelectionChangedListener(this);
        }
    }

    private int getSelected() {
        return this.selected;
    }

    private void updateOutput() {
        this.output.setText(this.getCurrentConfigBean().getBean().getSelectedPeriodSet().toString());
    }

    private ConfigBean getCurrentConfigBean() {
        return this.configurators[this.getSelected()];
    }

    private void setSelected(int selected) {
        if (selected == this.getSelected()) {
            return;
        }
        this.mainPane.remove(this.getCurrentConfigBean());
        this.selected = selected;
        this.mainPane.add((Component)this.getCurrentConfigBean(), "Center");
        this.selectedBeanNameLabel.setText(this.getCurrentConfigBean().getBeanDisplayName());
        this.mainPane.validate();
        this.updateOutput();
    }

    private void setCentered() {
        this.setSize(630, 380);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        if (this.getWidth() > screenSize.width || this.getHeight() > screenSize.height) {
            this.setLocation(0, 0);
        } else {
            this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        }
    }

    public void onCommit(CommitEvent evt) {
        this.updateOutput();
    }

    public void onSelectionChange(SelectionChangedEvent evt) {
        this.updateOutput();
    }

    private File getFileName(File start, String title, String approveName, boolean isOpen) {
        this.fileChooser.setDialogType(isOpen ? 0 : 1);
        if (start != null) {
            this.fileChooser.setSelectedFile(start);
        }
        if (approveName != null) {
            this.fileChooser.setApproveButtonText(approveName);
        }
        this.fileChooser.setApproveButtonText(approveName);
        this.fileChooser.setDialogTitle(title);
        int result = this.fileChooser.showDialog(this, null);
        if (result != 0) {
            return null;
        }
        return this.fileChooser.getSelectedFile();
    }

    private class OnBeanChange
    implements ActionListener {
        private OnBeanChange() {
        }

        public void actionPerformed(ActionEvent e) {
            Integer newBeanIndex = (Integer)((JCheckBoxMenuItem)e.getSource()).getClientProperty(ConfigWindow.MENU_PROPERTY_ID);
            ConfigWindow.this.setSelected(newBeanIndex);
        }
    }

    private class OnLookAndFeelChange
    implements ActionListener {
        private OnLookAndFeelChange() {
        }

        public void actionPerformed(ActionEvent e) {
            String newLFClassName = (String)((JCheckBoxMenuItem)e.getSource()).getClientProperty(ConfigWindow.MENU_PROPERTY_ID);
            if (newLFClassName.equals(UIManager.getLookAndFeel().getClass().getName())) {
                return;
            }
            try {
                UIManager.setLookAndFeel(newLFClassName);
                SwingUtilities.updateComponentTreeUI(ConfigWindow.this.getFrame());
                for (ConfigBean beanConfigurator : ConfigWindow.this.configurators) {
                    SwingUtilities.updateComponentTreeUI(beanConfigurator);
                    SwingUtilities.updateComponentTreeUI(ConfigWindow.this.fileChooser);
                }
                ConfigWindow.this.getFrame().repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class ComponentFileFilter
    extends FileFilter {
        private ComponentFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(ConfigWindow.this.getCurrentConfigBean().getFileExt());
        }

        public String getDescription() {
            return ConfigWindow.this.getCurrentConfigBean().getBeanDisplayName();
        }
    }

    private class OnStoreAction
    implements ActionListener {
        private OnStoreAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String action = (String)((JMenuItem)e.getSource()).getClientProperty(ConfigWindow.MENU_PROPERTY_ID);
            if (action.equals(ConfigWindow.MENU_LOAD)) {
                this.loadFromFile();
            }
            if (action.equals(ConfigWindow.MENU_SAVE)) {
                this.saveToFile(false);
            }
            if (action.equals(ConfigWindow.MENU_SAVE_AS)) {
                this.saveToFile(true);
            }
        }

        private void sayIfNotOK(String status) {
            if (status.equals("ok")) {
                return;
            }
            StringBuffer mess = new StringBuffer("<html><i>");
            mess.append(LocaleUtils.getConfigLocaleString("OperationErrorMessage"));
            mess.append("</i><br><br>");
            mess.append(status);
            JOptionPane.showMessageDialog(ConfigWindow.this.getFrame(), mess.toString(), LocaleUtils.getConfigLocaleString("OperationError"), 0);
        }

        private void loadFromFile() {
            int result;
            ConfigBean configBean = ConfigWindow.this.getCurrentConfigBean();
            if (!configBean.isSaved() && (result = JOptionPane.showConfirmDialog(ConfigWindow.this.getFrame(), LocaleUtils.getConfigLocaleString("ConfigLost"), LocaleUtils.getConfigLocaleString("Load"), 2)) == 2) {
                return;
            }
            File file = ConfigWindow.this.getFileName(configBean.getFile(), configBean.getBeanDisplayName(), LocaleUtils.getConfigLocaleString("Load"), true);
            if (file == null) {
                return;
            }
            this.sayIfNotOK(configBean.readFromFile(file));
        }

        private void saveToFile(boolean saveAs) {
            ConfigBean configBean = ConfigWindow.this.getCurrentConfigBean();
            if (!saveAs && configBean.isSaved() && configBean.getFile() != null) {
                return;
            }
            File file = configBean.getFile();
            if (saveAs || file == null) {
                if (file == null) {
                    file = new File(configBean.getBeanInfo().getBeanDescriptor().getName());
                }
                if ((file = ConfigWindow.this.getFileName(file, configBean.getBeanDisplayName(), LocaleUtils.getConfigLocaleString("Save"), false)) == null) {
                    return;
                }
                if (!file.getPath().endsWith(configBean.getFileExt())) {
                    file = new File(file.getPath() + "." + configBean.getFileExt());
                }
            }
            this.sayIfNotOK(configBean.writeToFile(file));
        }
    }

    private class OnWindowClose
    extends WindowAdapter {
        private OnWindowClose() {
        }

        public void windowClosing(WindowEvent e) {
            ConfigWindow.this.tryToExit();
        }
    }
}

