/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.customizer.render;

import datechooser.beans.customizer.PropertyDescriptorsHolder;
import datechooser.beans.customizer.render.CellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ValueCellRenderer
extends CellRenderer {
    private RenderPane paneRenderer = new RenderPane();
    private JLabel labelRenderer = new JLabel();
    private JCheckBox checkRenderer;
    private JComboBox comboRenderer;
    private JButton editorButton;
    private JPanel editorPane;
    private Component rendererCash = null;

    public ValueCellRenderer(PropertyDescriptorsHolder holder) {
        super(holder);
        this.labelRenderer.setOpaque(true);
        this.labelRenderer.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.checkRenderer = new JCheckBox();
        this.comboRenderer = new JComboBox();
        this.comboRenderer.setBorder(null);
        this.editorButton = new JButton("...");
        this.editorButton.setMargin(new Insets(2, 2, 2, 2));
        this.editorPane = new JPanel(new BorderLayout());
        this.editorPane.add((Component)this.editorButton, "East");
        UIManager.addPropertyChangeListener(new OnUIChange());
    }

    protected Component getRenderer(PropertyDescriptor propertyDescriptor, PropertyEditorSupport propertyEditorSupport, JTable table, boolean isSelected, boolean hasFocus) {
        JComponent renderer = null;
        if (PropertyDescriptorsHolder.isBooleanDescriptor(propertyDescriptor)) {
            this.checkRenderer.setSelected((Boolean)propertyEditorSupport.getValue());
            renderer = this.checkRenderer;
        } else if (propertyEditorSupport.getTags() != null) {
            this.comboRenderer.removeAllItems();
            this.comboRenderer.addItem(propertyEditorSupport.getAsText());
            renderer = this.comboRenderer;
        } else if (propertyEditorSupport.isPaintable()) {
            this.paneRenderer.setEditor(propertyEditorSupport);
            renderer = this.paneRenderer;
        } else {
            String text = propertyEditorSupport.getAsText();
            this.labelRenderer.setFont(table.getFont());
            this.labelRenderer.setText(text);
            renderer = this.labelRenderer;
        }
        ((Component)renderer).setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        ((Component)renderer).setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        if (propertyEditorSupport.supportsCustomEditor()) {
            if (this.rendererCash != null) {
                this.editorPane.remove(this.rendererCash);
            }
            this.editorPane.add((Component)renderer, "Center");
            this.rendererCash = renderer;
            this.editorPane.revalidate();
            return this.editorPane;
        }
        return renderer;
    }

    private class OnUIChange
    implements PropertyChangeListener {
        private OnUIChange() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.updateComponentTreeUI(ValueCellRenderer.this.editorPane);
            ValueCellRenderer.this.comboRenderer.updateUI();
            ValueCellRenderer.this.labelRenderer.updateUI();
            ValueCellRenderer.this.checkRenderer.updateUI();
        }
    }

    private class RenderPane
    extends JPanel {
        private PropertyEditor editor = null;

        private RenderPane() {
        }

        public void setEditor(PropertyEditor editor) {
            this.editor = editor;
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.editor == null) {
                return;
            }
            Rectangle bounds = this.getBounds();
            bounds.setLocation(5, 0);
            this.editor.paintValue(g, bounds);
        }
    }
}

