/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.backrender;

import datechooser.beans.locale.LocaleUtils;
import datechooser.view.BackRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class BackRendererEditorPane
extends JPanel
implements PropertyChangeListener {
    private PropertyEditorSupport editor = null;
    private JComboBox selStyle;
    private Preview previewPane;
    private JFileChooser fileChoose = new JFileChooser();

    public BackRendererEditorPane(PropertyEditorSupport editor) {
        this.setEditor(editor);
        this.generateInterface();
        this.updateInterface();
    }

    public void setEditor(PropertyEditorSupport editor) {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this);
        }
        this.editor = editor;
        editor.addPropertyChangeListener(this);
    }

    private void updateInterface() {
        BackRenderer renderer = this.getEditorValue();
        if (renderer == null) {
            return;
        }
        this.selStyle.setSelectedIndex(renderer.getStyle());
        this.previewPane.repaint();
    }

    private void generateInterface() {
        this.selStyle = this.createStyleChooser();
        this.previewPane = new Preview();
        JButton bFile = this.createFileButton();
        this.previewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
        this.setLayout(new BorderLayout());
        JPanel controlPane = new JPanel(new GridLayout(1, 2, 2, 2));
        JPanel selStylePane = new JPanel(new FlowLayout(1));
        JPanel buttonPane = new JPanel(new FlowLayout(1));
        buttonPane.add(bFile);
        selStylePane.add(this.selStyle);
        controlPane.add(selStylePane);
        controlPane.add(buttonPane);
        this.add((Component)controlPane, "North");
        this.add((Component)this.previewPane, "Center");
        this.revalidate();
    }

    private JComboBox createStyleChooser() {
        JComboBox<String> combo = new JComboBox<String>(new String[]{LocaleUtils.getEditorLocaleString("BackImageCenter"), LocaleUtils.getEditorLocaleString("BackImageFill"), LocaleUtils.getEditorLocaleString("BackImageTile")});
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BackRendererEditorPane.this.setStyle(BackRendererEditorPane.this.selStyle.getSelectedIndex());
            }
        });
        return combo;
    }

    private JButton createFileButton() {
        JButton button = new JButton(LocaleUtils.getEditorLocaleString("Load"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = BackRendererEditorPane.this.fileChoose.showOpenDialog(null);
                if (result != 0) {
                    return;
                }
                try {
                    BackRendererEditorPane.this.setURL(BackRendererEditorPane.this.fileChoose.getSelectedFile().toURL());
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        });
        return button;
    }

    private void setStyle(int style) {
        BackRenderer value = this.getEditorValue();
        if (value == null || style == value.getStyle()) {
            return;
        }
        this.editor.setValue(new BackRenderer(style, value != null ? value.getUrl() : null, this.getEditorValue().getImage()));
    }

    private void setURL(URL url) {
        BackRenderer value = this.getEditorValue();
        if (value != null && url.equals(value.getUrl())) {
            return;
        }
        this.editor.setValue(new BackRenderer(this.selStyle.getSelectedIndex(), url));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateInterface();
    }

    private BackRenderer getEditorValue() {
        return (BackRenderer)this.editor.getValue();
    }

    private class Preview
    extends JPanel {
        private Preview() {
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            BackRenderer renderer = BackRendererEditorPane.this.getEditorValue();
            if (renderer == null) {
                return;
            }
            renderer.render((Graphics2D)g, this.getBounds());
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 200);
        }
    }
}

