/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.utils.InsetsPanel;
import datechooser.beans.locale.LocaleUtils;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class EmptyBorderEditor
extends AbstractBorderEditor
implements PropertyChangeListener {
    private Insets insets;
    private InsetsPanel insetsPane;

    public EmptyBorderEditor() {
        this.initialize();
        this.setCaption(LocaleUtils.getEditorLocaleString("Empty"));
        this.insetsPane = new InsetsPanel(this.insets);
        this.insetsPane.addPropertyChangeListener(this);
        this.add(this.insetsPane);
        this.refreshInterface();
    }

    public void prepareSelection() {
        this.setValue(new EmptyBorder(this.insets));
    }

    protected EmptyBorder getValue() {
        return (EmptyBorder)this.value;
    }

    public void refreshInterface() {
        Insets currIns = this.getValue().getBorderInsets();
        this.insets.set(currIns.top, currIns.left, currIns.bottom, currIns.right);
        this.insetsPane.refresh();
    }

    protected Border getDefaultValue() {
        this.insets = new Insets(1, 1, 1, 1);
        return new EmptyBorder(this.insets);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!"insets".equals(evt.getPropertyName())) {
            return;
        }
        this.fireChange();
    }
}

