/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.cell;

import datechooser.beans.locale.LocaleUtils;
import datechooser.beans.pic.Pictures;
import datechooser.view.appearance.CellAppearance;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

class CellDraw
extends JPanel {
    private static final int PART = 2;
    private static final int BORDER = 5;
    private CellAppearance look;
    private Rectangle cellBounds;
    private boolean manualEdited;
    private transient Image backImage;

    public CellDraw(CellAppearance look) {
        try {
            this.backImage = ImageIO.read(Pictures.getDefaultPicture());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.cellBounds = new Rectangle();
        this.setLook(look);
        this.refreshSize();
    }

    private void refreshSize() {
        this.setManualEdited(false);
        this.initSize();
    }

    private void initSize() {
        Rectangle panelBounds = this.getBounds();
        if (!this.isManualEdited()) {
            this.cellBounds.width = panelBounds.width / 2;
            this.cellBounds.height = panelBounds.height / 2;
        }
        this.cellBounds.x = (panelBounds.width - this.cellBounds.width) / 2;
        this.cellBounds.y = (panelBounds.height - this.cellBounds.height) / 2;
    }

    public void processCurrentSize() {
        if (!this.isManualEdited()) {
            this.refreshSize();
        } else {
            Rectangle panelBounds = this.getBounds();
            if (this.getCellWidth() + 5 >= panelBounds.width || this.getCellHeight() + 5 >= panelBounds.height) {
                this.refreshSize();
            } else {
                this.initSize();
            }
        }
    }

    private void drawCenteredImage(Graphics2D g) {
        Rectangle rec = this.getBounds();
        g.drawImage(this.backImage, (rec.width - this.backImage.getWidth(null)) / 2, (rec.height - this.backImage.getHeight(null)) / 2, this.backImage.getWidth(null), this.backImage.getHeight(null), null);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.processCurrentSize();
        Graphics2D g2d = (Graphics2D)g;
        if (this.look.getComposite() != null) {
            this.drawCenteredImage(g2d);
        }
        g2d.translate(this.cellBounds.x, this.cellBounds.y);
        this.look.render(g2d, this, LocaleUtils.getEditorLocaleString("26"), this.cellBounds.width, this.cellBounds.height, true);
    }

    public CellAppearance getLook() {
        return this.look;
    }

    public void setLook(CellAppearance look) {
        this.look = look;
    }

    public boolean isManualEdited() {
        return this.manualEdited;
    }

    public void setManualEdited(boolean manualEdited) {
        this.manualEdited = manualEdited;
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    private void changeWidth(int width, int panelWidth) {
        this.cellBounds.x = (panelWidth - width) / 2;
        this.cellBounds.width = width;
    }

    private void changeHeight(int height, int panelHeight) {
        this.cellBounds.y = (panelHeight - height) / 2;
        this.cellBounds.height = height;
    }

    public int setCellWidth(int width) {
        Rectangle panelBounds = this.getBounds();
        if ((double)(width + 5) < panelBounds.getWidth()) {
            this.changeWidth(width, panelBounds.width);
            this.setManualEdited(true);
        }
        return this.getCellWidth();
    }

    public int setCellHeight(int height) {
        Rectangle panelBounds = this.getBounds();
        if ((double)(height + 5) < panelBounds.getHeight()) {
            this.changeHeight(height, panelBounds.height);
            this.setManualEdited(true);
        }
        return this.getCellHeight();
    }

    public int getCellWidth() {
        return this.cellBounds.width;
    }

    public int getCellHeight() {
        return this.cellBounds.height;
    }

    public int getMaxWidth() {
        Rectangle panelBounds = this.getBounds();
        return panelBounds.width - 5;
    }

    public int getMaxHeight() {
        Rectangle panelBounds = this.getBounds();
        return panelBounds.height - 5;
    }
}

