/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.cell;

import datechooser.beans.editor.border.SimpleBorderEditor;
import datechooser.beans.editor.cell.CellEditorPane;
import datechooser.beans.editor.cell.MainCellEditorPane;
import datechooser.beans.editor.utils.EditorDialog;
import datechooser.beans.locale.LocaleUtils;
import datechooser.view.appearance.custom.CustomCellAppearance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CustomCellEditorPane
extends CellEditorPane {
    private EditorDialog borderEditorDialog;
    private boolean innerEdit;
    private JSlider slider;

    public CustomCellEditorPane(MainCellEditorPane parentEditor) {
        super(parentEditor);
        this.setInnerEdit(false);
        this.borderEditorDialog = new EditorDialog((Frame)this.getParent(), new SimpleBorderEditor());
    }

    protected void updateEditorState() {
        if (this.isInnerEdit()) {
            return;
        }
        if (this.slider == null) {
            return;
        }
        this.slider.setValue((int)((double)this.getCustomValue().getTransparency() * 100.0));
    }

    protected void generateInterface() {
        this.setLayout(new BorderLayout(2, 2));
        JPanel buttons = new JPanel(new GridLayout(2, 1, 5, 5));
        JPanel line1 = new JPanel(new GridLayout(1, 2, 5, 5));
        JPanel line2 = new JPanel(new GridLayout(1, 3, 5, 5));
        JPanel line3 = new JPanel(new GridLayout(1, 1, 5, 5));
        line1.add(this.createBackgroundChooseButton());
        line1.add(this.createCursorColorChooseButton());
        line2.add(this.createTextColorChooseButton());
        line2.add(this.createFontChooseButton());
        line2.add(this.createBorderChooseButton());
        line3.add(this.createTransparencySlider());
        buttons.add(line1);
        buttons.add(line2);
        this.add((Component)buttons, "North");
        this.add((Component)line3, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private JPanel createTransparencySlider() {
        JPanel sliderPane = new JPanel(new BorderLayout(2, 5));
        JLabel sliderText = new JLabel(LocaleUtils.getEditorLocaleString("Transparency"));
        this.slider = new JSlider(0, 100, 100);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setInverted(true);
        this.slider.setExtent(10);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomCellEditorPane.this.setInnerEdit(true);
                CustomCellEditorPane.this.getCustomValue().setTransparency((float)CustomCellEditorPane.this.slider.getValue() / 100.0f);
                CustomCellEditorPane.this.getMainEditor().fireLocalPropertyChange();
                CustomCellEditorPane.this.setInnerEdit(false);
            }
        });
        sliderPane.add((Component)sliderText, "West");
        sliderPane.add((Component)this.slider, "Center");
        return sliderPane;
    }

    private JButton createBackgroundChooseButton() {
        JButton selBackColor = new JButton(LocaleUtils.getEditorLocaleString("Background_color"));
        selBackColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomCellEditorPane.this.getCustomValue().setBackgroundColor(CustomCellEditorPane.this.selectColor(CustomCellEditorPane.this.getCustomValue().getBackgroundColor(), LocaleUtils.getEditorLocaleString("Select_background_color")));
                CustomCellEditorPane.this.getMainEditor().fireLocalPropertyChange();
            }
        });
        return selBackColor;
    }

    private JButton createBorderChooseButton() {
        JButton bBorder = new JButton(LocaleUtils.getEditorLocaleString("Border"));
        bBorder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Border newBorder = (Border)CustomCellEditorPane.this.borderEditorDialog.showDialog(CustomCellEditorPane.this.getCustomValue().getCellBorder(), LocaleUtils.getEditorLocaleString("Select_border"));
                if (!CustomCellEditorPane.this.borderEditorDialog.isCanceled()) {
                    CustomCellEditorPane.this.getCustomValue().setCellBorder(newBorder);
                    CustomCellEditorPane.this.getMainEditor().fireLocalPropertyChange();
                }
            }
        });
        return bBorder;
    }

    private CustomCellAppearance getCustomValue() {
        return (CustomCellAppearance)this.getValue();
    }

    public boolean isInnerEdit() {
        return this.innerEdit;
    }

    public void setInnerEdit(boolean innerEdit) {
        this.innerEdit = innerEdit;
    }
}

