/*
 * Decompiled with CFR 0.152.
 */
package datechooser.model.multiple;

import datechooser.model.DateUtils;
import datechooser.model.multiple.DateOutputStyle;
import datechooser.model.multiple.Period;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodSet
extends DateOutputStyle
implements Serializable,
Cloneable {
    private LinkedList<Period> data = new LinkedList();
    private Period periodCash = null;
    private Period lastAdded = null;

    public PeriodSet() {
    }

    public PeriodSet(PeriodSet src) {
        this();
        this.data.addAll(src.data);
    }

    public PeriodSet(Period ... periods) {
        this();
        for (Period elem : periods) {
            this.add((Period)elem.clone());
        }
    }

    public void add(Period newPeriod) {
        if (newPeriod == null) {
            return;
        }
        this.lastAdded = newPeriod;
        for (Period elem : this.data) {
            if (!elem.isIntersects(newPeriod) && !elem.isNear(newPeriod)) continue;
            elem.unite(newPeriod);
            return;
        }
        int insPos = -1;
        for (Period elem : this.data) {
            ++insPos;
            if (!DateUtils.before(newPeriod.getEndDate(), elem.getStartDate())) continue;
            this.data.add(insPos, newPeriod);
            return;
        }
        this.data.addLast(newPeriod);
    }

    public void add(PeriodSet periods) {
        if (periods == null) {
            return;
        }
        this.data.addAll(periods.data);
    }

    public void set(PeriodSet periods) {
        this.clear();
        this.add(periods);
    }

    public void add(Calendar date) {
        this.add(new Period(date));
    }

    public void add(Iterable<Period> newData) {
        for (Period elem : newData) {
            this.add(elem);
        }
    }

    public void set(Iterable<Period> newData) {
        this.clear();
        this.add(newData);
    }

    public Iterable<Calendar> getDates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        for (Period period : this.data) {
            result.addAll(period.listDates());
        }
        return result;
    }

    public Iterable<Period> getPeriods() {
        ArrayList<Period> result = new ArrayList<Period>();
        result.addAll(this.data);
        return result;
    }

    public boolean intersects(Period period) {
        if (period == null) {
            return false;
        }
        for (Period elem : this.data) {
            if (!elem.isIntersects(period)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(PeriodSet periods) {
        for (Period srcPeriod : this.data) {
            for (Period trgPeriod : periods.data) {
                if (!srcPeriod.isIntersects(trgPeriod)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean near(Period period) {
        for (Period srcPeriod : this.data) {
            if (!srcPeriod.isNear(period)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Calendar date) {
        if (date == null) {
            return false;
        }
        if (this.periodCash == null) {
            this.periodCash = new Period(date);
        } else {
            this.periodCash.set(date, date);
        }
        return this.intersects(this.periodCash);
    }

    public void clear() {
        this.data.clear();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Period getLastAddedPeriod() {
        return this.lastAdded;
    }

    public Calendar getFirstDate() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.get(0).getStartDate();
    }

    public Period getFirstPeriod() {
        if (this.data.isEmpty()) {
            return null;
        }
        return this.data.get(0);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        Calendar first = this.getFirstDate();
        if (first == null) {
            return null;
        }
        StringBuffer ans = new StringBuffer();
        boolean firstDate = true;
        for (Period elem : this.data) {
            if (!firstDate) {
                ans.append("; ");
            } else {
                firstDate = false;
            }
            ans.append(elem.toString());
        }
        return ans.toString();
    }

    public String toString(int fmtStyle, Locale locale) {
        return this.toString(DateFormat.getDateInstance(fmtStyle, locale));
    }

    public String toString(DateFormat format) {
        Calendar first = this.getFirstDate();
        if (first == null) {
            return null;
        }
        StringBuffer ans = new StringBuffer();
        boolean firstDate = true;
        for (Period elem : this.data) {
            if (!firstDate) {
                ans.append("; ");
            } else {
                firstDate = false;
            }
            ans.append(elem.toString(format));
        }
        return ans.toString();
    }

    public int getCount() {
        return this.data.size();
    }

    public Object clone() {
        return new PeriodSet(this);
    }

    public boolean isSingleDate() {
        if (this.data.size() != 1) {
            return false;
        }
        return this.data.get(0).isOneDate();
    }
}

